#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll key;
    ll coord;
} Pair;

int cmp(const void *a, const void *b) {
    Pair *p = (Pair *)a;
    Pair *q = (Pair *)b;
    if (p->key != q->key)
        return (p->key < q->key) ? -1 : 1;
    if (p->coord != q->coord)
        return (p->coord < q->coord) ? -1 : 1;
    return 0;
}

ll count_pairs(Pair *arr, int n) {
    qsort(arr, n, sizeof(Pair), cmp);
    ll res = 0;
    int i = 0;
    while (i < n) {
        int j = i;
        while (j < n && arr[j].key == arr[i].key) j++;
        ll k = j - i;

      
        res += k * (k - 1) / 2;
        i = j;
    }
    return res;
}

int main() {
    int N;
    scanf("%d", &N);
    Pair *u = malloc(N * sizeof(Pair));
    Pair *v = malloc(N * sizeof(Pair));

    for (int i = 0; i < N; i++) {
        ll x, y;
        scanf("%lld %lld", &x, &y);
        u[i].key = x + y; u[i].coord = x;
        v[i].key = x - y; v[i].coord = x;
    }

    ll ans = count_pairs(u, N) + count_pairs(v, N);
    printf("%lld\n", ans);

    free(u); free(v);
    return 0;
}